---
title: Leaked credentials detection · Cloudflare Web Application Firewall (WAF) docs
description: The leaked credentials traffic detection scans incoming requests
  for credentials (usernames and passwords) previously leaked from data
  breaches.
lastUpdated: 2025-10-22T18:19:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/detections/leaked-credentials/
  md: https://developers.cloudflare.com/waf/detections/leaked-credentials/index.md
---

The leaked credentials [traffic detection](https://developers.cloudflare.com/waf/detections/) scans incoming requests for credentials (usernames and passwords) previously leaked from [data breaches](https://www.cloudflare.com/learning/security/what-is-a-data-breach/).

Note

If you are currently using [Exposed Credentials Check](https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/) (a previous implementation) and want to upgrade to leaked credentials detection, refer to our [upgrade guide](https://developers.cloudflare.com/waf/managed-rules/check-for-exposed-credentials/upgrade-to-leaked-credentials-detection/).

## How it works

Once enabled, leaked credentials detection will scan incoming HTTP requests for known authentication patterns from common web apps and any custom detection locations you configure.

If Cloudflare detects authentication credentials in the request, those credentials are checked against a list of known leaked credentials. This list of credentials consists of:

* The [Have I been Pwned (HIBP)](https://haveibeenpwned.com) matched passwords dataset (passwords only)
* Cloudflare-collected credentials (usernames)

Cloudflare will populate the existing [leaked credentials fields](#leaked-credentials-fields) based on the scan results. You can check these results in the [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) dashboard, and use these fields in rule expressions ([custom rules](https://developers.cloudflare.com/waf/custom-rules/) or [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/)) to protect your application against the usage of compromised credentials by your end users, and also against leaked credential attacks. Cloudflare may detect leaked credentials either because an attacker is performing a [credential stuffing](https://www.cloudflare.com/learning/bots/what-is-credential-stuffing/) attack or because a legitimate end user is reusing a previously leaked password.

In addition, leaked credentials detection provides a [managed transform](https://developers.cloudflare.com/rules/transform/managed-transforms/reference/#add-leaked-credentials-checks-header) that adds an `Exposed-Credential-Check` request header with a value indicating which field was leaked. For example, if both username and password were previously leaked, the header value will be `1`; if only the password was leaked, the value will be `4`.

One common approach used in web applications when detecting the use of stolen credentials is to warn end users about the situation and ask them to update their password. You can do this based on the managed header received at your origin server.

Note

Cloudflare does not store, log, or retain plaintext end-user passwords when performing leaked credential checks. Passwords are hashed, converted into a cryptographic representation, and then compared against a database of leaked credentials.

## Availability

For details on available features per plan, refer to [Availability](https://developers.cloudflare.com/waf/detections/#availability) in the traffic detections page.

## Default scan locations

Leaked credentials detection includes rules for identifying credentials in HTTP requests for the following well-known web applications:

* Drupal
* Joomla
* Ghost
* Magento
* Plone
* WordPress
* Microsoft Exchange OWA

Additionally, the scan includes generic rules for other common web authentication patterns.

You can also configure [custom detection locations](#custom-detection-locations) to address the specific authentication mechanism used in your web applications. A custom detection location tells the Cloudflare WAF where to find usernames and passwords in HTTP requests of your web application.

## Custom detection locations

Note

Only available for Enterprise customers.

Sometimes, you may wish to specify where to find credentials in HTTP requests for the specific case of your web applications.

For example, if the JSON body of an HTTP authenticating a user looked like the following in your web application:

```json
{ "user": "<username>", "secret": "<password>" }
```

You could configure a custom detection location with the following settings:

* Custom location for username:\
  `lookup_json_string(http.request.body.raw, "user")`
* Custom location for password:\
  `lookup_json_string(http.request.body.raw, "secret")`

When specifying a custom detection location, only the location of the username field is required.

The following table includes example detection locations for different request types:

| Request type | Username location / Password location |
| - | - |
| JSON body | `lookup_json_string(http.request.body.raw, "user")` `lookup_json_string(http.request.body.raw, "secret")` |
| URL-encoded form | `url_decode(http.request.body.form["user"][0])` `url_decode(http.request.body.form["secret"][0])` |
| Multipart form | `url_decode(http.request.body.multipart["user"][0])` `url_decode(http.request.body.multipart["secret"][0])` |

Expressions used to specify custom detection locations can include the following fields and functions:

* Fields:

  * [`http.request.body.form`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.form/)
  * [`http.request.body.multipart`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.multipart/)
  * [`http.request.body.raw`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.raw/)
  * [`http.request.headers`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.headers/)
  * [`http.request.uri.query`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.uri.query/)

* Functions:

  * [`lookup_json_string()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#lookup_json_string)
  * [`url_decode()`](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/#url_decode)

For instructions on configuring a custom detection location, refer to [Get started](https://developers.cloudflare.com/waf/detections/leaked-credentials/get-started/#4-optional-configure-a-custom-detection-location).

## Leaked credentials fields

| Field | Description |
| - | - |
| Password Leaked [`cf.waf.credential_check.password_leaked`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.credential_check.password_leaked/) Boolean | Indicates whether the password detected in the request was previously leaked. Available on all plans. |
| User and Password Leaked [`cf.waf.credential_check.username_and_password_leaked`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.credential_check.username_and_password_leaked/) Boolean | Indicates whether the username-password pair detected in the request were previously leaked. Requires a Pro plan or above. |
| Username Leaked [`cf.waf.credential_check.username_leaked`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.credential_check.username_leaked/) Boolean | Indicates whether the username detected in the request was previously leaked. Requires an Enterprise plan. |
| Similar Password Leaked [`cf.waf.credential_check.username_password_similar`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.credential_check.username_password_similar/) Boolean | Indicates whether a similar version of the username and password credentials detected in the request were previously leaked. Requires an Enterprise plan. |
| Authentication detected [`cf.waf.auth_detected`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.waf.auth_detected/) Boolean | Indicates whether Cloudflare detected authentication credentials in the request. Requires an Enterprise plan. |
