---
title: Application Security reports · Cloudflare Security Center docs
description: Application Security reports provide cyber attack insights and
  trends for all of the Enterprise zones in your Cloudflare account.
lastUpdated: 2025-10-28T18:39:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/security-center/app-security-reports/
  md: https://developers.cloudflare.com/security-center/app-security-reports/index.md
---

Application Security reports provide cyber attack insights and trends for all of the Enterprise zones in your Cloudflare account.

The reports are automatically generated on a monthly basis.

You can access reports by going to the **Security reports** page or via the [API](#api). You can access reports from previous months by selecting the month from the dropdown.

[Go to **Security reports**](https://dash.cloudflare.com/?to=/:account/security-center/reports)

To download the report, select **Print report**.

Reports from before April 2025 can be accessed through **Security reports** > **Legacy reports**. Due to limitations in the legacy reports, some customers may not have reports for every month prior to April 2025.

The current reports are curated by Cloudflare and will be expanded to include more insights. The option to create custom reports, filter by various fields, and schedule reports will be added in upcoming improvements.

***

## Report types

Currently, only Application Security reports are available. They cover the entire suite of products such as [HTTP DDoS Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/), [WAF](https://developers.cloudflare.com/waf/), and [Bot Management](https://developers.cloudflare.com/bots/).

Reports for Application Performance, [Cloudflare One](https://developers.cloudflare.com/cloudflare-one/), and Network Services, such as [Magic Transit](https://developers.cloudflare.com/magic-transit/), will be made available in future improvements.

***

## Report layout

Each report includes the following sections:

* Executive summary
* Distribution of allowed and mitigated requests
* [Industry benchmarks](#industry-benchmarks) that show how you compare to your peers by selecting your industry
* Top five source countries of allowed traffic and mitigated traffic including a map visualization
* Top five most targeted hostnames
* Top five most effective mitigation rules

To view more details, apply filters, analyze the data, and generate ad-hoc reports, use the [Security Analytics dashboard](https://developers.cloudflare.com/waf/analytics/security-analytics/) or [Log Explorer](https://developers.cloudflare.com/log-explorer/).

### Industry benchmarks

Industry benchmarks provide additional context for your mitigated traffic by comparing your organization's attack activity against others in the same industry. These benchmarks help you understand whether the volume and frequency of attacks you experience are typical, higher, or lower than your peers — offering a clear sense of where your organization stands within its threat landscape.

Beyond providing context, benchmarks can also help demonstrate value to stakeholders by quantifying the scale of threats your organization faces and how effectively Cloudflare mitigates them. This information can be useful when communicating your security posture internally or when prioritizing future security investments.

To ensure fairness and accuracy, Cloudflare normalizes your data before comparison. For each month, we calculate the percentage of mitigated requests relative to the total requests across your account and eligible zones. This normalization ensures that benchmarks are based on relative attack intensity rather than total traffic volume so larger or smaller organizations can be compared meaningfully.

The result helps you interpret your mitigated traffic data in context. For example, you may see a statement such as "*You are in the top 25% most attacked companies in the Cosmetics industry.*" This insight enables you to better understand your threat exposure, communicate results to stakeholders, and understand value of the protection Cloudflare provides.

If your account is not assigned an industry or if the shown industry is incorrect, use the link within the report to select the correct industry.

It may take a while for your new selection to take effect, and it may only be applied to future reports.

If you have multiple Cloudflare accounts, select the industry that is most relevant for the specific account.

***

## Prerequisites

You must have at least one Enterprise zone. Application Security reports are automatically enabled on your Enterprise zone. No action is required.

If you do not have any Enterprise zones, a report will not be generated. If you have an account that is not older than one month, a report will not be generated yet.

### Required roles

A Cloudflare user must have one of the following [roles](https://developers.cloudflare.com/fundamentals/manage-members/roles/) to download Application Security reports:

* Super Administrator
* Administrator

***

## API

```sh
GET /accounts/{account_id}/reporting/policies
```

```sh
GET /accounts/{account_id}/reporting/policies/{policy_id}
```

```sh
GET /accounts/{account_id}/reporting/reports
```

```sh
GET /accounts/{account_id}/reporting/reports/{report_id}
```

Data returned by the API

* Account ID
* Account Name
* Account Industry
* Time range
* Total zones
* Total zones analyzed
* Industry percentile (nullable float)
* Total requests (count, percentage)
* Total mitigated requests (count, percentage)
* Total served requests (count, percentage)
* Top 5 hostnames by mitigated requests (hostname, count)
* Top 5 source countries by served requests (country, count)
* Top 5 source countries by mitigated requests (country, count)
* Top 5 rules by mitigated requests (rule name, rule type, count)

Note

The data's time range is independent of when the report is generated.

### Cross-account reports

Each report is generated per account. You can use the [API](#api) to retrieve the reports for all of your accounts and aggregate the data.

***

## Limitations

Application Security reports currently only support US Customer Metadata Boundary (CMB). They do not support the EU CMB yet.

***

## Availability

This feature is available in closed beta to Enterprise customers.
