---
title: http.request.jwt.claims.nbf.sec.names · Cloudflare Ruleset Engine docs
description: The `nbf` (not before) claim identifies the time (number of
  seconds) before which the JWT must not be accepted for processing.
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.nbf.sec.names/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.jwt.claims.nbf.sec.names/index.md
---

# http.request.jwt.claims.nbf.sec.names

`http.request.jwt.claims.nbf.sec.names` Array\<String>

The `nbf` (not before) claim identifies the time (number of seconds) before which the JWT must not be accepted for processing.

For details, refer to the [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) in RFC 7519.

Requires a Cloudflare Enterprise plan with a paid add-on.

For more information on validating JSON Web Tokens, refer to [JSON Web Tokens Validation](https://developers.cloudflare.com/api-shield/security/jwt-validation/) in the API Shield documentation.

Categories:

* Request
* JWT validation
