---
title: Redirect from root to WWW · Cloudflare Rules docs
description: Create a redirect rule to forward HTTPS requests from the root
  (also known as the “apex” or “naked” domain) to the WWW subdomain.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-root-to-www/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-root-to-www/index.md
---

This example creates a redirect rule that forwards HTTPS requests from the root domain (`example.com`) to the WWW subdomain (`www.example.com`), while retaining the original path and query string.

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `https://example.com/*`

**Then**

* **Target URL**: `https://www.example.com/${1}`
* **Status code**: *301*
* **Preserve query string**: Enabled

This rule ensures that only HTTPS requests from the root domain are redirected to the WWW subdomain, leaving other requests (such as HTTP or requests to other subdomains) unchanged.

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `https://example.com/products/` | `https://www.example.com/products/` | `301` |
| `https://store.example.com/products/` | (unchanged) | n/a |
| `https://example.com/admin/?logged_out=true` | `https://www.example.com/admin/?logged_out=true` | `301` |
| `http://example.com/?all_items=true` | (unchanged) | n/a |
| `http://www.example.com/admin/` | (unchanged) | n/a |

Make sure to replace `example.com` with your actual hostname before deploying your rule.
