---
title: Remove fields from API response · Cloudflare Rules docs
description: If origin responds with `JSON`, parse the response and delete
  fields to return a modified response.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/
  md: https://developers.cloudflare.com/rules/snippets/examples/remove-fields-api-response/index.md
---

```js
export default {
  async fetch(request) {
    // Send original request to the origin
    const response = await fetch(request);
    // Check if origin responded with JSON
    try {
      // Parse API response as JSON
      var api_response = response.json();
      // Specify the fields you want to delete. For example, to delete "botManagement" array from parsed JSON:
      delete api_response.botManagement;
      // Serve modified API response
      return Response.json(api_response);
    } catch (err) {
      // On failure, serve unmodified origin's response
      return response;
    }
  },
};
```
