---
title: Find by solution · Cloudflare Reference Architecture docs
description: Use the list below for reference architecture documentation that
  relates to a solution area you are interested in.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/reference-architecture/by-solution/
  md: https://developers.cloudflare.com/reference-architecture/by-solution/index.md
---

Use the list below for reference architecture documentation that relates to a solution area you are interested in.

### Cloudflare Connectivity Cloud

Content that pertains to the Cloudflare platform in general.

#### Reference architectures

* [Cloudflare security reference architecture](https://developers.cloudflare.com/reference-architecture/architectures/security/)
* [Multi-vendor Application Security and Performance Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/multi-vendor/)
* [Protect network infrastructure with Magic Transit](https://developers.cloudflare.com/reference-architecture/architectures/magic-transit/)
* [Protect Hybrid Cloud Networks with Cloudflare Magic Transit](https://developers.cloudflare.com/reference-architecture/diagrams/network/protect-hybrid-cloud-networks-with-cloudflare-magic-transit/)

#### Reference architecture diagrams

* [Protecting ISP and telecommunications networks from DDoS attacks](https://developers.cloudflare.com/reference-architecture/diagrams/network/protecting-sp-networks-from-ddos/)

#### Design guides

* [Extend Cloudflare's Benefits to SaaS Providers' End-Customers](https://developers.cloudflare.com/reference-architecture/design-guides/extending-cloudflares-benefits-to-saas-providers-end-customers/)

### Zero Trust / SASE

Architecture documentation related to using Cloudflare for Zero Trust, SSE and SASE initiatives for protecting your applications, data, employees and the corporate network.

#### Reference architectures

* [Evolving to a SASE architecture with Cloudflare](https://developers.cloudflare.com/reference-architecture/architectures/sase/)
* [Using Cloudflare SASE with Microsoft](https://developers.cloudflare.com/reference-architecture/architectures/cloudflare-sase-with-microsoft/)

#### Reference architecture diagrams

* [Access to private apps without having to deploy client agents](https://developers.cloudflare.com/reference-architecture/diagrams/sase/sase-clientless-access-private-dns/)
* [Securing data at rest](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-at-rest/)
* [Securing data in transit](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-transit/)
* [Securing data in use](https://developers.cloudflare.com/reference-architecture/diagrams/security/securing-data-in-use/)
* [Extend ZTNA with external authorization and serverless computing](https://developers.cloudflare.com/reference-architecture/diagrams/sase/augment-access-with-serverless/)
* [DNS filtering solution for Internet service providers](https://developers.cloudflare.com/reference-architecture/diagrams/sase/gateway-dns-for-isp/)
* [Magic WAN Connector deployment options](https://developers.cloudflare.com/reference-architecture/diagrams/sase/magic-wan-connector-deployment/)
* [Deploy self-hosted VoIP services for hybrid users](https://developers.cloudflare.com/reference-architecture/diagrams/sase/deploying-self-hosted-voip-services-for-hybrid-users/)

#### Design guides

* [Designing ZTNA access policies for Cloudflare Access](https://developers.cloudflare.com/reference-architecture/design-guides/designing-ztna-access-policies/)
* [Building zero trust architecture into your startup](https://developers.cloudflare.com/reference-architecture/design-guides/zero-trust-for-startups/)
* [Network-focused migration from VPN concentrators to Zero Trust Network Access](https://developers.cloudflare.com/reference-architecture/design-guides/network-vpn-migration/)
* [Using a zero trust framework to secure SaaS applications](https://developers.cloudflare.com/reference-architecture/design-guides/zero-trust-for-saas/)

#### Implementation guides

* [Secure your Internet traffic and SaaS apps](https://developers.cloudflare.com/learning-paths/secure-internet-traffic/concepts/)
* [Replace your VPN](https://developers.cloudflare.com/learning-paths/replace-vpn/concepts/)
* [Deploy clientless access](https://developers.cloudflare.com/learning-paths/clientless-access/concepts/)
* [Secure Microsoft 365 email with Email security](https://developers.cloudflare.com/learning-paths/secure-o365-email/concepts/)

### Networking

#### Reference architecture diagrams

* [Protect public networks with Cloudflare](https://developers.cloudflare.com/reference-architecture/diagrams/network/protect-public-networks-with-cloudflare/)
* [Bring your own IP space to Cloudflare](https://developers.cloudflare.com/reference-architecture/diagrams/network/bring-your-own-ip-space-to-cloudflare/)
* [Protect hybrid cloud networks with Cloudflare Magic Transit](https://developers.cloudflare.com/reference-architecture/diagrams/network/protect-hybrid-cloud-networks-with-cloudflare-magic-transit/)
* [Protect ISP and telecommunications networks from DDoS attacks](https://developers.cloudflare.com/reference-architecture/diagrams/network/protecting-sp-networks-from-ddos/)

### Application Performance

Content related to DNS, caching, load balancing and other Cloudflare services designed to improve application reliability and performance.

#### Reference architectures

* [Content Delivery Network](https://developers.cloudflare.com/reference-architecture/architectures/cdn/)
* [Load Balancing](https://developers.cloudflare.com/reference-architecture/architectures/load-balancing/)

### Application Security

Content related to protecting your applications from threats such as DDoS attack, SQL injection, exploiting application vulnerabilities, scraping API data and more.

#### Reference architecture diagrams

* [Bot management](https://developers.cloudflare.com/reference-architecture/diagrams/bots/bot-management/)

#### Design guides

* [Secure application delivery](https://developers.cloudflare.com/reference-architecture/design-guides/secure-application-delivery/)

#### Implementation guides

* [Use mTLS with Cloudflare protected resources](https://developers.cloudflare.com/learning-paths/mtls/concepts/)

### Developer Platform

Architecture content for our developer platform.

#### Reference architecture diagrams

##### AI

* [Automatic captioning for video uploads](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-video-caption/)
* [Composable AI architecture](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-composable/)
* [Content-based asset creation](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-asset-creation/)
* [Multi-vendor AI observability and control](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-multivendor-observability-control/)
* [Retrieval Augmented Generation (RAG)](https://developers.cloudflare.com/reference-architecture/diagrams/ai/ai-rag/)
* [Ingesting BigQuery Data into Workers AI](https://developers.cloudflare.com/reference-architecture/diagrams/ai/bigquery-workers-ai/)

##### Serverless

* [Optimizing Image Delivery with Cloudflare Image Resizing and R2](https://developers.cloudflare.com/reference-architecture/diagrams/content-delivery/optimizing-image-delivery-with-cloudflare-image-resizing-and-r2/)
* [A/B-testing using Workers](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/a-b-testing-using-workers/)
* [Fullstack Applications](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/fullstack-application/)
* [Serverless ETL pipelines](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/serverless-etl/)
* [Serverless global APIs](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/serverless-global-apis/)
* [Serverless image content management](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/serverless-image-content-management/)
* [Programmable Platforms](https://developers.cloudflare.com/reference-architecture/diagrams/serverless/programmable-platforms/)

##### Storage

* [Egress-free object storage in multi-cloud setups](https://developers.cloudflare.com/reference-architecture/diagrams/storage/egress-free-storage-multi-cloud/)
* [On-demand Object Storage Data Migration](https://developers.cloudflare.com/reference-architecture/diagrams/storage/on-demand-object-storage-migration/)
* [Event notifications for storage](https://developers.cloudflare.com/reference-architecture/diagrams/storage/event-notifications-for-storage/)
* [Storing User Generated Content](https://developers.cloudflare.com/reference-architecture/diagrams/storage/storing-user-generated-content/)
* [Control and data plane architectural pattern for Durable Objects](https://developers.cloudflare.com/reference-architecture/diagrams/storage/durable-object-control-data-plane-pattern/)
