---
title: Improve SEO · Cloudflare Fundamentals docs
description: The goal of Search Engine Optimization (SEO) is to get your website
  to rank higher on various search engine providers (Google, Bing, etc.).
lastUpdated: 2025-10-31T10:10:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/performance/improve-seo/
  md: https://developers.cloudflare.com/fundamentals/performance/improve-seo/index.md
---

The goal of Search Engine Optimization (SEO) is to get your website to rank higher on various search engine providers (Google, Bing, etc.).

In practice, SEO is primarily about quality content, user experience, and not making things more difficult for search engine crawlers. While Cloudflare cannot write quality content for you, our service can help with user experience — especially related to [site speed](https://www.cloudflare.com/learning/performance/how-website-speed-boosts-seo/) — and search crawlers.

Tip:

For general guidelines around SEO, refer to [Google's recommendations](https://developers.google.com/search/docs/advanced/guidelines/overview).

## SEO improvements with Cloudflare

Several Cloudflare features improve Search Engine site rankings. However, meaningful and regularly updated site content is still crucial to improving SEO.

### Increase site speed

Since at least 2010, Google has publicly stated that [site speed affects your Google ranking](https://webmasters.googleblog.com/2010/04/using-site-speed-in-web-search-ranking.html).

Cloudflare offers multiple features to [optimize site performance](https://developers.cloudflare.com/speed/).

### Enable HTTPS

Since search engines use HTTPS as [a ranking signal](https://webmasters.googleblog.com/2014/08/https-as-ranking-signal.html), HTTPS is vital for SEO.

To make sure your domain is accessible over HTTPS:

1. Get an [SSL/TLS certificate](https://developers.cloudflare.com/ssl/get-started/) for your domain.
2. [Redirect visitors](https://developers.cloudflare.com/ssl/edge-certificates/encrypt-visitor-traffic/) to the HTTPS version of your domain.

### Enable Crawler Hints

With [Crawler Hints](https://developers.cloudflare.com/cache/advanced-configuration/crawler-hints/), search engines and other bot-powered experiences have the freshest version of your content, translating into happier users and ultimately influencing search rankings.

## Troubleshooting

Depending on your domain's security settings, you might accidentally block search engine crawlers.

If you notice SEO issues, make sure your:

* [WAF custom rules](https://developers.cloudflare.com/waf/troubleshooting/faq/#caution-about-potentially-blocking-bots) are allowing **Verified Bots**.
* [Rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/) are allowing **Verified Bots**.
* [Bot protection](https://developers.cloudflare.com/bots/concepts/bot/verified-bots/) settings are not blocking **Verified Bots**.

If you still notice issues with search engine crawlers, refer to our [Troubleshooting guide](https://developers.cloudflare.com/support/troubleshooting/general-troubleshooting/troubleshooting-crawl-errors/).

## Common misconceptions

The following characteristics do not affect your domain's SEO:

* **Changing your nameservers**: Using Cloudflare's nameservers does not affect your domain's SEO.
* **Server location**: According to Google, [server location](http://www.seroundtable.com/seo-geo-location-server-google-17468.html) is not important for SEO.
* **Sites sharing IP addresses**: Search engines do not generally penalize domains using shared IP addresses unless several of these sites are malicious or spammy.
* **Cloudflare caching**: When Cloudflare caches your content, it actually speeds up content delivery and only improves SEO. Our caching does not create duplicate content, rewrite URLs, or create additional subdomains.
