---
title: DNS setups · Cloudflare DNS docs
description: "When using Cloudflare DNS, you have a few options for your DNS zone setup:"
lastUpdated: 2025-05-29T18:16:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/zone-setups/
  md: https://developers.cloudflare.com/dns/zone-setups/index.md
---

When using Cloudflare DNS, you have a few options for your DNS zone setup:

* [Full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/) (most common): Use Cloudflare as your primary DNS provider and manage your DNS records on Cloudflare.
* [Partial (CNAME) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/): Keep your primary DNS provider and only use Cloudflare's reverse proxy for individual subdomains.
* [Subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/): With your apex domain (`example.com`) on a partial or full setup, independently manage the settings for a specific subdomain (`blog.example.com`) within a separate zone and, potentially, a separate account.
* [Zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/): Use Cloudflare and another DNS provider together across your entire zone to increase availability and fault tolerance. DNS records will be transferred between providers using [AXFR](https://datatracker.ietf.org/doc/html/rfc5936) or [IXFR](https://datatracker.ietf.org/doc/html/rfc1995).

Note

If you run your own authoritative nameservers but still want to benefit from Cloudflare's global anycast network, check out [DNS Firewall](https://developers.cloudflare.com/dns/dns-firewall/).

## Zone status

For details on zone status, consider the [Reference page](https://developers.cloudflare.com/dns/zone-setups/reference/domain-status/).

Do not use pending zones in production

If you have a paid plan, make sure not to use pending zones for production traffic. Cloudflare responds to DNS queries for pending zones on the assigned Cloudflare nameserver IPs but there are associated risks, especially if you do not use [zone holds](https://developers.cloudflare.com/fundamentals/account/account-security/zone-holds/).

## Common use cases and availability

If you are unsure of which setup to use, consider the questions below for an overview of common use cases and their correspondence to each setup and [different pricing plans](https://www.cloudflare.com/plans/#overview).

Are you on a Free or Pro plan?

If you are on a Free or Pro plan, [full setup](https://developers.cloudflare.com/dns/zone-setups/full-setup/) is the only one available. This is the recommended and most common option.

Will you be using Cloudflare with other DNS providers?

If you are on a Business or Enterprise plan, you can use [partial (CNAME) setup](https://developers.cloudflare.com/dns/zone-setups/partial-setup/) to keep your primary DNS provider and only proxy individual subdomains through Cloudflare.

If you are on an Enterprise plan, you also have the option to use [zone transfers](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/) to set up Cloudflare as either a primary or a secondary DNS provider.

Do you need to manage subdomains separately?

If you are on an Enterprise plan, you can use [subdomain setup](https://developers.cloudflare.com/dns/zone-setups/subdomain-setup/) to manage the Cloudflare settings for one or more subdomains separately from your domain apex.
