---
title: FAQ · Cloudflare China Network docs
description: Review FAQs for Cloudflare's China Network.
lastUpdated: 2025-10-24T08:58:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/china-network/faq/
  md: https://developers.cloudflare.com/china-network/faq/index.md
---

## Prerequisites and onboarding

### What are the requirements to enable Cloudflare China Network service from Cloudflare?

Refer to [Get started](https://developers.cloudflare.com/china-network/get-started/) for more information.

### Can I use my current account to access Cloudflare China Network service?

Yes, you can use your current Cloudflare account and dashboard.

### What are the requirements for requesting a Cloudflare China Network PoC?

Cloudflare requires that you have a valid [ICP (Internet Content Provider)](https://developers.cloudflare.com/china-network/concepts/icp/) number and content vetting approval from JD Cloud to provide you with a Cloudflare China Network PoC (Proof of Concept). If you are interested in a PoC, please contact your sales team.

## Data storage

### Will my Cloudflare account or configuration information be stored in China?

Cloudflare has taken numerous steps to ensure your security and the integrity of your data in China. Your identification information such as email addresses, password hashes, and billing information are never stored on Cloudflare China Network or shared with the Cloudflare partner except for Zone configuration information and bindings with Cloudflare’s Developer Suite which are stored on the China Network operated by our partners in China upon your enabling the China Service for a particular Zone.

## Compliance

### Does Cloudflare have an MIIT license to provide CDN services in China?

As a US company, Cloudflare does not have a license from China's Ministry of Industry and Information Technology (MIIT). However, Cloudflare's partner JD Cloud has all the licenses required by the MIIT to operate and provide CDN services in China.

### Can Cloudflare or JD Cloud help me to get the ICP?

No, neither Cloudflare nor JD Cloud is responsible for [ICP (Internet Content Provider)](https://developers.cloudflare.com/china-network/concepts/icp/) applications. However, Cloudflare can help provide referrals to ICP partners specialized in ICP applications. For more information, refer to [Obtain an ICP number](https://developers.cloudflare.com/china-network/concepts/icp/#obtain-an-icp-number).

### Why is my ICP filing/license revoked?

The application and revocation of ICP filings or licenses is managed by China's local authorities. Usually, either the customer or the agency processing the ICP application will receive a notification with more details. Cloudflare cannot provide the ICP revocation reasons.

### What would happen if my ICP filing/license got revoked?

Cloudflare's partner JD Cloud and the local authorities continuously track the status of the ICP. If your ICP gets revoked, JD Cloud may terminate or suspend your access to the China Service at any time and without liability, in accordance with China local regulations. To mitigate the impact on your Internet properties, Cloudflare will reroute the traffic for the affected domains to the nearest data centers outside of China.

### What is content vetting and why do I need JD Cloud to vet my domain's content before onboarding?

The JD Cloud network is proxying content inside of China for customers who have purchased Cloudflare China Network. To ensure compliance with China’s Internet regulations and with [JD Cloud's service terms](https://docs.jdcloud.com/cn/product-service-agreement/starshield-terms-of-service), JD Cloud must review the content of all the domains before onboarding those domains to their network. They can approve or reject any domain based on the nature of its content. For more information, contact your sales team.

## Products and features

### How does IPv6 work on China Network?

All sites hosted in Mainland China must have IPv6 enabled. China Network automatically enables IPv6 for domains to fulfill this requirement and it is not possible to disable it. According to internal testing, IPv6 connections in Mainland China are more reliable and offer better latency.

### Is Turnstile available in Mainland China?

[Turnstile](https://developers.cloudflare.com/turnstile/) is not supported in Mainland China. Therefore, both China Network zones and [global zones](https://developers.cloudflare.com/fundamentals/concepts/accounts-and-zones/#zones) with users visiting your content from Mainland China may experience issues with Turnstile.

### Is Pages available in Mainland China?

[Pages](https://developers.cloudflare.com/pages/) is not available in Mainland China due to pages.dev certificate not residing within Mainland China. However, Pages from a global zone may potentially be extended into Mainland China.
